/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.dialog;

import com.fb.tpe.Data;
import com.fb.tpe.model.data.ItemObject;
import com.fb.tpe.model.data.ItemObjectDAO;
import com.fb.tpe.view.GUI;
import com.fb.tpe.view.ui.field.ItemCellRenderer;
import com.fb.tpe.view.ui.layout.SpringUtilities;
import com.fb.tpe.view.ui.panel.EquipPanelInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EquipChooserDialog
extends JDialog {
    private static final long serialVersionUID = -6603897306226600314L;
    private EquipPanelInterface _parent;
    private int _itemType;
    private ItemObject _choice;
    private ItemObject[] _itemObjects;
    private ItemObject _curItemObject;
    JPanel panelBorder;
    JPanel panelContent;
    JPanel panelControls;
    JPanel panelFilter;
    JLabel labelFilter;
    JLabel labelSpacer;
    JTextField editFilter;
    JButton buttonCancel;
    JScrollPane scrollList;
    JPanel panelList;
    ItemCellRenderer itemCellRenderer;
    JList listItems;
    WindowFocusListener listenerWindowFocus = new WindowFocusListener(){

        @Override
        public void windowGainedFocus(WindowEvent event) {
            EquipChooserDialog.this.requestFilterFocus();
        }

        @Override
        public void windowLostFocus(WindowEvent event) {
            EquipChooserDialog.this.dialogLostFocus(event);
        }
    };
    ActionListener listenerButtonCancel = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            EquipChooserDialog.this.pressCancelButton();
        }
    };
    ListSelectionListener listenerItemList = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent event) {
            EquipChooserDialog.this.clickItemList(event);
        }
    };
    DocumentListener listenerDocumentFilter = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent event) {
            EquipChooserDialog.this.setListData();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            EquipChooserDialog.this.setListData();
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            EquipChooserDialog.this.setListData();
        }
    };

    private EquipChooserDialog(JFrame owner, EquipPanelInterface parent, int itemType, ItemObject curItemObject) {
        super(owner);
        this._parent = parent;
        this._itemType = itemType;
        this._curItemObject = curItemObject;
        this.initGUI();
        this.populateFields();
    }

    public static void equipChooserDialog(JFrame owner, EquipPanelInterface parent, Point location, int itemType, ItemObject curItemObject) {
        EquipChooserDialog ecd = new EquipChooserDialog(owner, parent, itemType, curItemObject);
        ecd.pack();
        ecd.setLocation(location);
        ecd.setVisible(true);
    }

    public ItemObject getChosenItem() {
        return this._choice;
    }

    private void setListData() {
        ItemObject[] filteredItems;
        ArrayList<ItemObject> filteredList = new ArrayList<ItemObject>();
        String filterValue = this.editFilter.getText().toLowerCase();
        if (!filterValue.isEmpty()) {
            filteredList.add(this._itemObjects[0]);
            int index = 1;
            while (index < this._itemObjects.length) {
                String itemName = this._itemObjects[index].getItemName().toLowerCase();
                if (itemName.contains(filterValue)) {
                    filteredList.add(this._itemObjects[index]);
                }
                ++index;
            }
            filteredItems = new ItemObject[filteredList.size()];
            filteredList.toArray(filteredItems);
        } else {
            filteredItems = this._itemObjects;
        }
        this.listItems.setListData(filteredItems);
    }

    private void populateFields() {
        this.itemCellRenderer.setCurrentObject(this._curItemObject);
        this._itemObjects = ItemObjectDAO.getItemObjectsByType(this._itemType, true);
        this.setListData();
        this.editFilter.requestFocusInWindow();
    }

    private void dialogLostFocus(WindowEvent event) {
        if (event.getOppositeWindow() != null && SwingUtilities.isDescendingFrom(event.getOppositeWindow(), this)) {
            return;
        }
        this.pressCancelButton();
    }

    private void pressCancelButton() {
        this.setVisible(false);
    }

    private void clickItemList(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting() && !this.listItems.isSelectionEmpty()) {
            this._choice = (ItemObject)this.listItems.getSelectedValue();
            this._parent.chooseItemPanel(this._choice);
            Data.setCharacterDirty();
            this.setVisible(false);
        }
    }

    private void registerEscapeKey() {
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EquipChooserDialog.this.pressCancelButton();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void requestFilterFocus() {
        this.editFilter.requestFocusInWindow();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setBackground(GUI.colorChooserBack);
        this.addWindowFocusListener(this.listenerWindowFocus);
        this.setAlwaysOnTop(true);
        this.registerEscapeKey();
        this.panelBorder = new JPanel(new SpringLayout());
        this.panelBorder.setBackground(GUI.colorChooserBack);
        this.panelContent = new JPanel(new BorderLayout());
        this.panelControls = new JPanel(new BorderLayout());
        this.panelControls.setBorder(GUI.borderEmptyLRT5px);
        this.panelControls.setBackground(GUI.colorChooserFront);
        this.panelFilter = new JPanel(new BorderLayout());
        this.labelFilter = new JLabel(" Filter: ");
        this.panelFilter.setBackground(GUI.colorChooserFront);
        this.editFilter = new JTextField("");
        this.editFilter.setBorder(GUI.borderEditField);
        this.editFilter.getDocument().addDocumentListener(this.listenerDocumentFilter);
        this.labelSpacer = new JLabel("     ");
        this.buttonCancel = new JButton("X");
        this.buttonCancel.setFocusPainted(false);
        this.buttonCancel.addActionListener(this.listenerButtonCancel);
        this.scrollList = new JScrollPane();
        this.scrollList.setVerticalScrollBarPolicy(22);
        this.scrollList.setHorizontalScrollBarPolicy(31);
        this.panelList = new JPanel(new BorderLayout());
        this.panelList.setBackground(GUI.colorChooserFront);
        this.listItems = new JList();
        this.listItems.setSelectionMode(0);
        this.itemCellRenderer = new ItemCellRenderer();
        this.listItems.setCellRenderer(this.itemCellRenderer);
        this.listItems.setBackground(GUI.colorItemCell);
        this.listItems.addListSelectionListener(this.listenerItemList);
        this.add(this.panelBorder);
        this.panelBorder.add((Component)this.panelContent, "Center");
        this.panelContent.add((Component)this.panelControls, "North");
        this.panelControls.add((Component)this.panelFilter, "Center");
        this.panelFilter.add((Component)this.labelFilter, "West");
        this.panelFilter.add((Component)this.editFilter, "Center");
        this.panelFilter.add((Component)this.labelSpacer, "East");
        this.panelContent.add((Component)this.panelList, "South");
        this.panelList.add((Component)this.scrollList, "Center");
        this.scrollList.getViewport().add(this.listItems);
        SpringUtilities.makeCompactGrid(this.panelBorder, 1, 1, 2, 2, 2, 2);
    }
}

