/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.dialog;

import com.fb.tpe.Data;
import com.fb.tpe.model.data.ItemObject;
import com.fb.tpe.model.data.ItemObjectDAO;
import com.fb.tpe.view.GUI;
import com.fb.tpe.view.ui.field.ItemCellRenderer;
import com.fb.tpe.view.ui.panel.ItemPanelInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ItemChooserDialog
extends JDialog {
    private static final long serialVersionUID = -3488869292578425348L;
    private ItemPanelInterface _parent;
    private int _itemType;
    private boolean _showControls;
    private ItemObject _choice;
    private ItemObject[] _itemObjects;
    private ItemObject _curItemObject;
    private boolean[] _filters;
    JPanel panelBorder;
    JPanel panelContent;
    JPanel panelControls;
    JCheckBox checkAll;
    JPanel panelFilter;
    JLabel labelFilter;
    JLabel labelSpacer;
    JTextField editFilter;
    JPanel panelLimits;
    JCheckBox checkAccess;
    JCheckBox checkAmmunition;
    JCheckBox checkArmor;
    JCheckBox checkBuilding;
    JCheckBox checkCoins;
    JCheckBox checkConsumable;
    JCheckBox checkFurniture;
    JCheckBox checkLghting;
    JCheckBox checkMisc;
    JCheckBox checkOres;
    JCheckBox checkPotions;
    JCheckBox checkStatues;
    JCheckBox checkTools;
    JCheckBox checkWeaponsAll;
    JCheckBox checkWeaponsMagical;
    JCheckBox checkWeaponsMelee;
    JCheckBox checkWeaponsRanged;
    JButton buttonCancel;
    JScrollPane scrollList;
    JPanel panelList;
    ItemCellRenderer itemCellRenderer;
    JList listItems;
    WindowFocusListener listenerWindowFocus = new WindowFocusListener(){

        @Override
        public void windowGainedFocus(WindowEvent event) {
            ItemChooserDialog.this.requestFilterFocus();
        }

        @Override
        public void windowLostFocus(WindowEvent event) {
            ItemChooserDialog.this.dialogLostFocus(event);
        }
    };
    ActionListener listenerButtonCancel = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            ItemChooserDialog.this.pressCancelButton();
        }
    };
    ItemListener listenerCheckbox = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent event) {
            ItemChooserDialog.this.clickCheckbox(event);
        }
    };
    ListSelectionListener listenerItemList = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent event) {
            ItemChooserDialog.this.clickItemList(event);
        }
    };
    DocumentListener listenerDocumentFilter = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent event) {
            ItemChooserDialog.this.setListData();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            ItemChooserDialog.this.setListData();
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            ItemChooserDialog.this.setListData();
        }
    };

    private ItemChooserDialog(JFrame owner, ItemPanelInterface parent, boolean showControls, int itemType, ItemObject curItemObject) {
        super(owner);
        this._parent = parent;
        this._showControls = showControls;
        this._itemType = itemType;
        this._curItemObject = curItemObject;
        this._filters = this.resetFilters();
        this.initGUI();
        this.populateFields();
    }

    public static void itemChooserDialog(JFrame owner, ItemPanelInterface parent, Point location, boolean showControls, int itemType, ItemObject curItemObject) {
        ItemChooserDialog icd = new ItemChooserDialog(owner, parent, showControls, itemType, curItemObject);
        icd.pack();
        icd.setLocation(location);
        icd.setVisible(true);
    }

    private void setListData() {
        ItemObject[] filteredItems;
        ArrayList<ItemObject> filteredList = new ArrayList<ItemObject>();
        String filterValue = this.editFilter.getText().toLowerCase();
        if (!filterValue.isEmpty()) {
            filteredList.add(this._itemObjects[0]);
            int index = 1;
            while (index < this._itemObjects.length) {
                String itemName = this._itemObjects[index].getItemName().toLowerCase();
                if (itemName.contains(filterValue)) {
                    filteredList.add(this._itemObjects[index]);
                }
                ++index;
            }
            filteredItems = new ItemObject[filteredList.size()];
            filteredList.toArray(filteredItems);
        } else {
            filteredItems = this._itemObjects;
        }
        this.listItems.setListData(filteredItems);
    }

    private void populateFields() {
        this.itemCellRenderer.setCurrentObject(this._curItemObject);
        this._itemObjects = ItemObjectDAO.getItemObjectsByType(this._itemType, true);
        this.setListData();
        this.editFilter.requestFocusInWindow();
    }

    private boolean[] resetFilters() {
        boolean[] result = new boolean[31];
        result[2] = true;
        result[1] = true;
        result[4] = true;
        result[3] = true;
        result[5] = true;
        result[6] = true;
        result[7] = true;
        result[8] = true;
        result[9] = true;
        result[10] = true;
        result[11] = true;
        result[12] = true;
        result[13] = true;
        result[14] = true;
        result[15] = true;
        result[16] = true;
        result[17] = true;
        result[18] = true;
        result[19] = true;
        result[20] = true;
        result[21] = true;
        result[22] = true;
        result[23] = true;
        result[24] = true;
        result[25] = true;
        result[26] = true;
        result[27] = true;
        result[28] = true;
        result[29] = true;
        result[30] = true;
        return result;
    }

    private void dialogLostFocus(WindowEvent event) {
        if (event.getOppositeWindow() != null && SwingUtilities.isDescendingFrom(event.getOppositeWindow(), this)) {
            return;
        }
        this.pressCancelButton();
    }

    private void pressCancelButton() {
        this.setVisible(false);
    }

    private void clickCheckbox(ItemEvent event) {
        ItemSelectable source = event.getItemSelectable();
        int state = event.getStateChange();
        if (source == this.checkAll) {
            this.clickCheckAll(state);
        } else {
            this.clickItemType(source, state);
            this._itemObjects = ItemObjectDAO.getFilteredItems(this._filters);
        }
        this.setListData();
    }

    private void clickCheckAll(int state) {
        JCheckBox checkbox;
        int index;
        if (state == 1) {
            index = 0;
            while (index < this.panelLimits.getComponentCount()) {
                checkbox = (JCheckBox)this.panelLimits.getComponent(index);
                checkbox.setEnabled(false);
                checkbox.setSelected(true);
                this._itemObjects = ItemObjectDAO.getAllItems();
                ++index;
            }
        }
        if (state == 2) {
            index = 0;
            while (index < this.panelLimits.getComponentCount()) {
                checkbox = (JCheckBox)this.panelLimits.getComponent(index);
                checkbox.setEnabled(true);
                checkbox.setSelected(false);
                this._itemObjects = new ItemObject[1];
                this._itemObjects[0] = ItemObjectDAO.getEmptyItem();
                ++index;
            }
        }
    }

    private void clickItemType(Object source, int state) {
        boolean setting;
        boolean bl = setting = state == 1;
        if (source == this.checkAccess) {
            this._filters[1] = setting;
        }
        if (source == this.checkArmor) {
            this._filters[4] = setting;
            this._filters[3] = setting;
            this._filters[5] = setting;
        }
        if (source == this.checkAmmunition) {
            this._filters[2] = setting;
        }
        if (source == this.checkBuilding) {
            this._filters[6] = setting;
        }
        if (source == this.checkConsumable) {
            this._filters[8] = setting;
        }
        if (source == this.checkFurniture) {
            this._filters[9] = setting;
        }
        if (source == this.checkLghting) {
            this._filters[10] = setting;
        }
        if (source == this.checkMisc) {
            this._filters[7] = setting;
            this._filters[11] = setting;
        }
        if (source == this.checkOres) {
            this._filters[12] = setting;
        }
        if (source == this.checkPotions) {
            this._filters[13] = setting;
        }
        if (source == this.checkStatues) {
            this._filters[14] = setting;
        }
        if (source == this.checkTools) {
            this._filters[15] = setting;
            this._filters[16] = setting;
            this._filters[17] = setting;
            this._filters[18] = setting;
            this._filters[19] = setting;
            this._filters[20] = setting;
            this._filters[21] = setting;
        }
        if (source == this.checkWeaponsAll) {
            this.clickCheckWeapons(setting);
        }
        if (source == this.checkWeaponsMagical) {
            this._filters[27] = setting;
        }
        if (source == this.checkWeaponsMelee) {
            this._filters[28] = setting;
            this._filters[29] = setting;
        }
        if (source == this.checkWeaponsRanged) {
            this._filters[22] = setting;
            this._filters[23] = setting;
            this._filters[25] = setting;
            this._filters[26] = setting;
            this._filters[30] = setting;
            this._filters[24] = setting;
        }
    }

    private void clickCheckWeapons(boolean setting) {
        this._filters[27] = setting;
        this.checkWeaponsMagical.setEnabled(!setting);
        this.checkWeaponsMelee.setEnabled(!setting);
        this.checkWeaponsRanged.setEnabled(!setting);
        this.checkWeaponsMagical.setSelected(setting);
        this.checkWeaponsMelee.setSelected(setting);
        this.checkWeaponsRanged.setSelected(setting);
    }

    private void clickItemList(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting() && !this.listItems.isSelectionEmpty()) {
            this._choice = (ItemObject)this.listItems.getSelectedValue();
            if (this._choice != null) {
                if (this._choice.getItemId() != 603) {
                    this._parent.chooseItemPanel(this._choice);
                } else {
                    JOptionPane.showMessageDialog(Data.getView(), "This item, the Carrot, is a Collector's Edition only item.\nYou may not add it here.", "Carrot Not Available", 0);
                }
            }
            Data.setCharacterDirty();
            this.setVisible(false);
        }
    }

    private void requestFilterFocus() {
        this.editFilter.requestFocusInWindow();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setBackground(GUI.colorChooserBack);
        this.addWindowFocusListener(this.listenerWindowFocus);
        this.setAlwaysOnTop(true);
        this.registerEscapeKey();
        this.panelBorder = new JPanel(new GridLayout(1, 1));
        this.panelBorder.setBackground(GUI.colorChooserBack);
        this.panelContent = new JPanel(new BorderLayout());
        this.panelControls = new JPanel(new BorderLayout());
        this.panelControls.setBorder(GUI.borderChooserCtls);
        this.panelControls.setBackground(GUI.colorChooserFront);
        this.checkAll = this.setupCheckbox("All");
        this.panelFilter = new JPanel(new BorderLayout());
        this.labelFilter = new JLabel("     Filter: ");
        this.panelFilter.setBackground(GUI.colorChooserFront);
        this.editFilter = new JTextField("");
        this.editFilter.setBorder(GUI.borderEditField);
        this.editFilter.getDocument().addDocumentListener(this.listenerDocumentFilter);
        this.editFilter.setToolTipText("Enter a filter to limit items listed");
        this.labelSpacer = new JLabel("     ");
        this.panelLimits = new JPanel(new GridLayout(0, 4));
        this.panelLimits.setBackground(GUI.colorChooserFront);
        this.panelLimits.setBorder(GUI.borderChooserCtls);
        this.panelLimits.setToolTipText("Limit Items by Type");
        this.checkAccess = this.setupCheckbox("Access");
        this.checkAmmunition = this.setupCheckbox("Ammo");
        this.checkArmor = this.setupCheckbox("Armor");
        this.checkBuilding = this.setupCheckbox("Building");
        this.checkCoins = this.setupCheckbox("Coins");
        this.checkConsumable = this.setupCheckbox("Consum");
        this.checkFurniture = this.setupCheckbox("Furniture");
        this.checkLghting = this.setupCheckbox("Lighting");
        this.checkMisc = this.setupCheckbox("Misc");
        this.checkOres = this.setupCheckbox("Ores");
        this.checkPotions = this.setupCheckbox("Potions");
        this.checkStatues = this.setupCheckbox("Statues");
        this.checkTools = this.setupCheckbox("Tools");
        this.checkWeaponsAll = this.setupCheckbox("Weapons");
        this.checkWeaponsMagical = this.setupCheckbox("Magical");
        this.checkWeaponsMelee = this.setupCheckbox("Melee");
        this.checkWeaponsRanged = this.setupCheckbox("Ranged");
        this.buttonCancel = new JButton("X");
        this.buttonCancel.setFocusPainted(false);
        this.buttonCancel.setToolTipText("Cancel item selection");
        this.buttonCancel.addActionListener(this.listenerButtonCancel);
        this.scrollList = new JScrollPane();
        this.scrollList.setVerticalScrollBarPolicy(22);
        this.scrollList.setHorizontalScrollBarPolicy(31);
        this.panelList = new JPanel(new BorderLayout());
        this.panelList.setBackground(GUI.colorChooserFront);
        this.listItems = new JList();
        this.listItems.setSelectionMode(0);
        this.itemCellRenderer = new ItemCellRenderer();
        this.listItems.setCellRenderer(this.itemCellRenderer);
        this.listItems.setBackground(GUI.colorItemCell);
        this.listItems.addListSelectionListener(this.listenerItemList);
        this.add(this.panelBorder);
        this.panelBorder.add((Component)this.panelContent, "Center");
        this.panelContent.add((Component)this.panelControls, "North");
        this.panelControls.add((Component)this.checkAll, "West");
        this.panelControls.add((Component)this.panelFilter, "Center");
        this.panelFilter.add((Component)this.labelFilter, "West");
        this.panelFilter.add((Component)this.editFilter, "Center");
        this.panelFilter.add((Component)this.labelSpacer, "East");
        if (this._showControls) {
            this.checkAll.setEnabled(true);
            this.panelContent.add((Component)this.panelLimits, "Center");
            this.panelLimits.add(this.checkAccess);
            this.panelLimits.add(this.checkArmor);
            this.panelLimits.add(this.checkAmmunition);
            this.panelLimits.add(this.checkBuilding);
            this.panelLimits.add(this.checkConsumable);
            this.panelLimits.add(this.checkFurniture);
            this.panelLimits.add(this.checkLghting);
            this.panelLimits.add(this.checkMisc);
            this.panelLimits.add(this.checkOres);
            this.panelLimits.add(this.checkPotions);
            this.panelLimits.add(this.checkStatues);
            this.panelLimits.add(this.checkTools);
            this.panelLimits.add(this.checkWeaponsAll);
            this.panelLimits.add(this.checkWeaponsMelee);
            this.panelLimits.add(this.checkWeaponsRanged);
            this.panelLimits.add(this.checkWeaponsMagical);
        } else {
            this.checkAll.setEnabled(false);
        }
        this.panelContent.add((Component)this.panelList, "South");
        this.panelList.add((Component)this.scrollList, "Center");
        this.scrollList.getViewport().add(this.listItems);
    }

    private void registerEscapeKey() {
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ItemChooserDialog.this.pressCancelButton();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private JCheckBox setupCheckbox(String text) {
        JCheckBox result = new JCheckBox(text, true);
        result.setBackground(GUI.colorChooserFront);
        result.setEnabled(false);
        result.setFocusPainted(false);
        result.addItemListener(this.listenerCheckbox);
        return result;
    }
}

