/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.menu;

import com.fb.tpe.Data;
import com.fb.tpe.TerrariaPlayerEditor;
import com.fb.tpe.view.GUI;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class MenuHelp
extends JMenu {
    private static final long serialVersionUID = 5925942359615711626L;
    private int _mnemonic;
    JMenuItem menuHelpReadMe;
    JMenuItem menuHelpAbout;
    ActionListener listenerMenuHelpReadMe = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuHelp.this.eventMenuHelpReadMe();
        }
    };
    ActionListener listenerMenuHelpAbout = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuHelp.this.eventMenuHelpAbout();
        }
    };

    public MenuHelp(String name, int mnemonic) {
        super(name);
        this._mnemonic = mnemonic;
        this.initGUI();
    }

    public void eventMenuHelpReadMe() {
        InputStream stream = null;
        InputStreamReader reader = null;
        String inputFile = "res/text/ReadMe-TPE.txt";
        JTextArea textArea = new JTextArea(20, 41);
        textArea.setEditable(false);
        textArea.setMargin(new Insets(2, 2, 2, 2));
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(inputFile);
            reader = new InputStreamReader(stream);
            textArea.read(reader, null);
            JOptionPane.showMessageDialog(Data.getView(), new JScrollPane(textArea), "Terraria Player Editor (v1.08) Read Me", 1, Data.getView().getAppImage());
        }
        catch (IOException error) {
            JOptionPane.showMessageDialog(Data.getView(), "I/O Error: " + inputFile + ": " + error.getMessage(), "I/O Error: Terraria Player Editor (v1.08)", 0);
        }
        catch (NullPointerException error) {
            JOptionPane.showMessageDialog(Data.getView(), "I/O Error: " + inputFile + ": " + error.getMessage(), "I/O Error: Terraria Player Editor (v1.08)", 0);
            TerrariaPlayerEditor.throwError();
        }
    }

    public void eventMenuHelpAbout() {
        String message = "Terraria Player Editor (v1.08)\nCopyright (c) to proper owners\nData interface by AlyoshaV\nUser interface by _Jon\nDesign based on TerrariViewer";
        JOptionPane.showMessageDialog(Data.getView(), message, "Terraria Player Editor (v1.08)", 1);
    }

    private void initGUI() {
        this.setFont(GUI.fontSsP14);
        this.setMnemonic(this._mnemonic);
        this.menuHelpReadMe = this.setupMenuItem("Read Me", "Display the Read Me file", 82, 0, this.listenerMenuHelpReadMe, true);
        this.menuHelpAbout = this.setupMenuItem("About", "Show the About information", 65, 0, this.listenerMenuHelpAbout, true);
        this.add(this.menuHelpReadMe);
        this.add(this.menuHelpAbout);
    }

    private JMenuItem setupMenuItem(String menuName, String toolTip, int mnemonic, int keyEvent, ActionListener listener, boolean enabled) {
        JMenuItem result = new JMenuItem();
        result.setText(menuName);
        result.setToolTipText(toolTip);
        result.setFont(GUI.fontSsP14);
        result.setMnemonic(mnemonic);
        if (keyEvent != 0) {
            result.setAccelerator(KeyStroke.getKeyStroke(keyEvent, 2));
        }
        result.setEnabled(enabled);
        result.addActionListener(listener);
        return result;
    }
}

