/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.panel;

import com.fb.tpe.Data;
import com.fb.tpe.TerrariaPlayerEditor;
import com.fb.tpe.model.data.ItemObject;
import com.fb.tpe.model.data.ItemObjectDAO;
import com.fb.tpe.model.data.PrefixObject;
import com.fb.tpe.model.data.PrefixObjectDAO;
import com.fb.tpe.view.GUI;
import com.fb.tpe.view.dialog.ItemChooserDialog;
import com.fb.tpe.view.dialog.PrefixChooserDialog;
import com.fb.tpe.view.ui.panel.ItemPanel;
import com.fb.tpe.view.ui.panel.ItemPanelInterface;
import com.su.slytherin.terraria.player.InvStack;
import com.su.slytherin.terraria.player.Item;
import com.su.slytherin.terraria.player.Player;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class BankPanel
extends JPanel
implements ItemPanelInterface {
    private static final long serialVersionUID = -4408583640925496700L;
    private Player _player;
    private InvStack _bank;
    private ItemPanel _itemPanel;
    JPanel panelBank;

    public BankPanel() {
        this.initGUI();
    }

    public void populateFields() {
        this._player = Data.getPlayer();
        if (this._player != null) {
            this._bank = this._player.getBank();
            if (this._bank != null) {
                int position = 0;
                while (position < 20) {
                    ItemPanel itemPanel = (ItemPanel)this.panelBank.getComponent(position);
                    Item item = this._bank.getItem(position);
                    int prefixId = item.getPrefix();
                    ItemObject itemObject = ItemObjectDAO.getItemObjectById(item.getItemId());
                    BankPanel.setItemPanel(itemPanel, itemObject, prefixId, this._bank.getItemCount(position));
                    ++position;
                }
            } else {
                JOptionPane.showMessageDialog(Data.getView(), "Unable to load bank data", "Bank Error", 0);
                TerrariaPlayerEditor.throwError();
            }
        } else {
            JOptionPane.showMessageDialog(Data.getView(), "Unable to load player data", "Player Error", 0);
            TerrariaPlayerEditor.throwError();
        }
    }

    public void updatePlayer() {
        int position = 0;
        while (position < 20) {
            ItemPanel itemPanel = (ItemPanel)this.panelBank.getComponent(position);
            Item item = Item.of(itemPanel.getItemId(), itemPanel.getPrefixId());
            this._bank.setItem(position, item);
            this._bank.setItemCount(position, itemPanel.getItemCount());
            ++position;
        }
        this._player.setBank(this._bank);
        Data.setPlayer(this._player);
    }

    public void clearAll() {
        int position = 0;
        while (position < 20) {
            ItemPanel itemPanel = (ItemPanel)this.panelBank.getComponent(position);
            BankPanel.setItemPanel(itemPanel, null, 0, 0);
            ++position;
        }
    }

    private static void setItemPanel(ItemPanel itemPanel, ItemObject itemObject, int prefixId, int itemCount) {
        if (itemObject != null && !itemObject.equals(ItemObjectDAO.getEmptyItem())) {
            String count = itemCount != 0 ? Integer.toString(itemCount) : "";
            itemPanel.setItem(itemObject, prefixId, count);
        } else {
            itemPanel.setItem(ItemObjectDAO.getEmptyItem(), 0, "");
        }
    }

    @Override
    public void clickItemPanel(ItemPanel itemPanel, int itemType) {
        boolean showControls = true;
        this._itemPanel = itemPanel;
        Point location = itemPanel.getLocationOnScreen();
        location.x += itemPanel.getWidth();
        location.y -= 105;
        ItemChooserDialog.itemChooserDialog(Data.getView(), this, location, showControls, itemType, itemPanel.getItemObject());
    }

    @Override
    public void chooseItemPanel(ItemObject chosenItem) {
        int itemCount = 1;
        if (chosenItem != null) {
            if (Data.getUseMaxAmount()) {
                itemCount = chosenItem.getItemMaxCount();
                if (!Data.getLimitAmounts() && chosenItem.getItemMaxCount() > 1) {
                    itemCount = 999;
                }
            }
            BankPanel.setItemPanel(this._itemPanel, chosenItem, 0, itemCount);
        }
    }

    @Override
    public void clickPrefix(ItemPanel itemPanel) {
        this._itemPanel = itemPanel;
        int itemType = itemPanel.getItemObject().getItemType();
        PrefixObject prefixObject = PrefixObjectDAO.getPrefixObjectById(itemPanel.getPrefixId());
        Point location = itemPanel.getLocationOnScreen();
        location.y -= 8;
        PrefixChooserDialog.prefixChooserDialog((JFrame)Data.getView(), this, location, itemType, prefixObject);
    }

    @Override
    public void choosePrefix(PrefixObject chosenPrefix) {
        ItemObject currentItem;
        int itemCount = 1;
        if (this._itemPanel != null && (currentItem = this._itemPanel.getItemObject()) != null) {
            if (Data.getUseMaxAmount()) {
                itemCount = currentItem.getItemMaxCount();
            }
            BankPanel.setItemPanel(this._itemPanel, currentItem, chosenPrefix.getPrefixId(), itemCount);
        }
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.panelBank = new JPanel(new GridLayout(4, 5));
        this.panelBank.setBorder(GUI.setupAreaBorder("Piggy Bank"));
        this.panelBank.setOpaque(false);
        this.add((Component)this.panelBank, "West");
        int position = 0;
        while (position < 20) {
            this.panelBank.add(new ItemPanel(this, 0, GUI.colorBankInv));
            ++position;
        }
        this.add(Box.createHorizontalGlue(), "Center");
    }
}

