/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.ui.field;

import com.fb.tpe.model.data.PrefixObject;
import com.fb.tpe.view.GUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class PrefixCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 4594415657249310990L;
    private PrefixObject _currentObject;

    public void setCurrentObject(PrefixObject currentObject) {
        this._currentObject = currentObject;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        JLabel result = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
        if (value instanceof PrefixObject) {
            PrefixObject prefixObject = (PrefixObject)value;
            result.setBorder(GUI.borderList);
            String toolTip = "<html><font color=\"blue\"><b>" + prefixObject.getPrefixName() + "</b></font><br/>" + prefixObject.getPrefixTip() + "</html>";
            result.setToolTipText(toolTip);
            result.setBackground(GUI.colorPrefixCell);
            if (prefixObject.equals(this._currentObject)) {
                result.setBackground(GUI.colorPrefixSelCell);
            }
            if (selected) {
                result.setBackground(GUI.colorPrefixFocusCell);
            }
            result.setFont(GUI.fontSsB14);
            FontMetrics fontMetrics = result.getFontMetrics(result.getFont());
            int labelWidth = fontMetrics.stringWidth(result.getText());
            int width = GUI.DIM_ICON.width * 2 + labelWidth;
            int height = GUI.DIM_ICON.height;
            result.setPreferredSize(new Dimension(width, height));
            result.setMinimumSize(new Dimension(width, height));
            result.setMaximumSize(new Dimension(width, height));
        }
        return result;
    }
}

