/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.ui.panel;

import com.fb.tpe.Data;
import com.fb.tpe.model.data.HairObject;
import com.fb.tpe.model.data.HairObjectDAO;
import com.fb.tpe.view.GUI;
import com.fb.tpe.view.ui.field.ColorComboRenderer;
import com.fb.tpe.view.ui.field.DocumentInteger;
import com.fb.tpe.view.ui.field.HairCellRenderer;
import com.fb.tpe.view.ui.layout.SpringUtilities;
import com.su.slytherin.terraria.player.Player;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class AppearanceSubPanel
extends JPanel {
    private static final long serialVersionUID = -2683110901493027626L;
    private Player _player;
    private HairObject _selectedHairStyle;
    private Color _selectedHairColor = Color.BLACK;
    private static final int HAIR = 0;
    private static final int SKIN = 1;
    private static final int EYES = 2;
    private static final int OSHI = 3;
    private static final int USHI = 4;
    private static final int PANT = 5;
    private static final int SHOE = 6;
    private static final int BODY_PARTS = 7;
    private static final String CARD_SELECTORS = "Selectors";
    private static final String CARD_RGBS = "Direct Entry";
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    JPanel panelHairColors;
    JPanel panelHairstyle;
    JPanel panelColorLabels;
    JPanel panelColors;
    CardLayout layoutcardColorCards;
    JPanel panelColorCards;
    JPanel panelSelectors;
    JPanel panelRGB;
    JPanel panelRGBTitles;
    JPanel[] panelRGBs = new JPanel[7];
    JPanel panelColorSpacer;
    JComboBox[] comboColors = new JComboBox[7];
    JTextField[][] editColorRGBs = new JTextField[7][];
    JPanel panelHairImage;
    JLabel labelHairstyle;
    JComboBox comboHairStyle;
    HairCellRenderer hairCellRenderer;
    JPanel panelImage;
    JLabel imageChar;
    JLabel imageHair;
    JLabel imageHead;
    JLabel imageHand;
    JLabel imageEyes;
    JLabel imageOShi;
    JLabel imageUShi;
    JLabel imagePant;
    JLabel imageShoe;
    ActionListener listenerComboHairStyle = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            AppearanceSubPanel.this.clickComboHairstyles();
        }
    };
    ActionListener listenerComboColor = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            AppearanceSubPanel.this.clickComboColor(event);
        }
    };
    FocusListener listenerFocusColor = new FocusListener(){

        @Override
        public void focusGained(FocusEvent event) {
            AppearanceSubPanel.this.updateEditColorFocus(event);
        }

        @Override
        public void focusLost(FocusEvent event) {
            AppearanceSubPanel.this.updateEditColorFocus(event);
        }
    };

    public AppearanceSubPanel() {
        this.initGUI();
    }

    public void showSelectors() {
        this.layoutcardColorCards.show(this.panelColorCards, CARD_SELECTORS);
    }

    public void showRGB() {
        this.layoutcardColorCards.show(this.panelColorCards, CARD_RGBS);
    }

    public void populateFields(Player player) {
        this._player = player;
        this.comboHairStyle.setSelectedIndex(player.getHairstyle());
        this._selectedHairStyle = HairObjectDAO.getHairObjectByNum(player.getHairstyle() + 1);
        this.hairCellRenderer.setCurrentObject(this._selectedHairStyle);
        this.comboHairStyle.setEnabled(true);
        this.populateColorComboBoxes();
        this.populateColorRGBs();
    }

    public void updatePlayer(Player player) {
        player.setHairstyle(this.comboHairStyle.getSelectedIndex());
        if (Data.getColorSelectors()) {
            player.setHairColor((Color)this.comboColors[0].getSelectedItem());
            player.setSkinColor((Color)this.comboColors[1].getSelectedItem());
            player.setEyeColor((Color)this.comboColors[2].getSelectedItem());
            player.setOShirtColor((Color)this.comboColors[3].getSelectedItem());
            player.setUShirtColor((Color)this.comboColors[4].getSelectedItem());
            player.setPantsColor((Color)this.comboColors[5].getSelectedItem());
            player.setShoeColor((Color)this.comboColors[6].getSelectedItem());
        } else {
            player.setHairColor(this.getRGBColor(this.editColorRGBs[0]));
            player.setSkinColor(this.getRGBColor(this.editColorRGBs[1]));
            player.setEyeColor(this.getRGBColor(this.editColorRGBs[2]));
            player.setOShirtColor(this.getRGBColor(this.editColorRGBs[3]));
            player.setUShirtColor(this.getRGBColor(this.editColorRGBs[4]));
            player.setPantsColor(this.getRGBColor(this.editColorRGBs[5]));
            player.setShoeColor(this.getRGBColor(this.editColorRGBs[6]));
        }
    }

    public void randomizeCharacter() {
        Random random = new Random();
        int hairstyle = random.nextInt(32);
        this.comboHairStyle.setSelectedIndex(hairstyle);
        this._selectedHairStyle = HairObjectDAO.getHairObjectByNum(hairstyle + 1);
        this.hairCellRenderer.setCurrentObject(this._selectedHairStyle);
        this.comboHairStyle.setEnabled(true);
        Color[] colors = Data.getCharacterColorChoices();
        int index = 0;
        while (index < 7) {
            AppearanceSubPanel.setColorComboBox(this.comboColors[index], colors[random.nextInt(colors.length)]);
            this.setColorRGB(this.editColorRGBs[index], (Color)this.comboColors[index].getSelectedItem());
            ++index;
        }
    }

    private void clickComboHairstyles() {
        HairObject hairObject = (HairObject)this.comboHairStyle.getSelectedItem();
        if (hairObject != null) {
            this._selectedHairStyle = hairObject;
            this.changeHairColor();
        }
        Data.setCharacterDirty();
    }

    private void clickComboColor(ActionEvent event) {
        ImageIcon icon;
        JComboBox source = (JComboBox)event.getSource();
        Color selectedColor = (Color)source.getSelectedItem();
        ColorComboRenderer renderer = (ColorComboRenderer)source.getRenderer();
        renderer.setCurrentObject(selectedColor);
        Data.setCharacterDirty();
        if (source.equals(this.comboColors[0])) {
            this._selectedHairColor = selectedColor;
            this.changeHairColor();
            if (Data.getColorSelectors()) {
                this.setColorRGB(this.editColorRGBs[0], selectedColor);
            }
        }
        if (source.equals(this.comboColors[1])) {
            icon = this.updateIcon(GUI.Icon_Head, selectedColor, this.imageHead);
            Data.getView().getEquipmentPanel().setHead(icon);
            icon = this.updateIcon(GUI.Icon_Hand, selectedColor, this.imageHand);
            Data.getView().getEquipmentPanel().setHand(icon);
            if (Data.getColorSelectors()) {
                this.setColorRGB(this.editColorRGBs[1], selectedColor);
            }
        }
        if (source.equals(this.comboColors[2])) {
            icon = this.updateIcon(GUI.Icon_Eyes, selectedColor, this.imageEyes);
            Data.getView().getEquipmentPanel().setEyes(icon);
            if (Data.getColorSelectors()) {
                this.setColorRGB(this.editColorRGBs[2], selectedColor);
            }
        }
        if (source.equals(this.comboColors[3])) {
            icon = this.updateIcon(GUI.Icon_OShi, selectedColor, this.imageOShi);
            Data.getView().getEquipmentPanel().setOShi(icon);
            if (Data.getColorSelectors()) {
                this.setColorRGB(this.editColorRGBs[3], selectedColor);
            }
        }
        if (source.equals(this.comboColors[4])) {
            icon = this.updateIcon(GUI.Icon_UShi, selectedColor, this.imageUShi);
            Data.getView().getEquipmentPanel().setUShi(icon);
            if (Data.getColorSelectors()) {
                this.setColorRGB(this.editColorRGBs[4], selectedColor);
            }
        }
        if (source.equals(this.comboColors[5])) {
            icon = this.updateIcon(GUI.Icon_Pant, selectedColor, this.imagePant);
            Data.getView().getEquipmentPanel().setPant(icon);
            if (Data.getColorSelectors()) {
                this.setColorRGB(this.editColorRGBs[5], selectedColor);
            }
        }
        if (source.equals(this.comboColors[6])) {
            icon = this.updateIcon(GUI.Icon_Shoe, selectedColor, this.imageShoe);
            Data.getView().getEquipmentPanel().setShoe(icon);
            if (Data.getColorSelectors()) {
                this.setColorRGB(this.editColorRGBs[6], selectedColor);
            }
        }
    }

    private void updateEditColorFocus(FocusEvent event) {
        Color oldColor = Color.white;
        Color newColor = Color.white;
        JComboBox comboColor = null;
        JTextField sourceField = (JTextField)event.getSource();
        if (event.paramString().startsWith("FOCUS_GAINED")) {
            sourceField.selectAll();
        }
        if (event.paramString().startsWith("FOCUS_LOST")) {
            String strValue = sourceField.getText();
            int intValue = Data.getIntegerValue(strValue);
            if (strValue.isEmpty() || intValue < 0) {
                sourceField.setText("0");
            }
            if (intValue > 255) {
                sourceField.setText(Integer.toString(255));
            }
            if (sourceField.getParent().equals(this.panelRGBs[0])) {
                oldColor = this._player.getHairColor();
                newColor = this.getRGBColor(this.editColorRGBs[0]);
                comboColor = this.comboColors[0];
            }
            if (sourceField.getParent().equals(this.panelRGBs[1])) {
                oldColor = this._player.getSkinColor();
                newColor = this.getRGBColor(this.editColorRGBs[1]);
                comboColor = this.comboColors[1];
            }
            if (sourceField.getParent().equals(this.panelRGBs[2])) {
                oldColor = this._player.getEyeColor();
                newColor = this.getRGBColor(this.editColorRGBs[2]);
                comboColor = this.comboColors[2];
            }
            if (sourceField.getParent().equals(this.panelRGBs[3])) {
                oldColor = this._player.getOShirtColor();
                newColor = this.getRGBColor(this.editColorRGBs[3]);
                comboColor = this.comboColors[3];
            }
            if (sourceField.getParent().equals(this.panelRGBs[4])) {
                oldColor = this._player.getUShirtColor();
                newColor = this.getRGBColor(this.editColorRGBs[4]);
                comboColor = this.comboColors[4];
            }
            if (sourceField.getParent().equals(this.panelRGBs[5])) {
                oldColor = this._player.getPantsColor();
                newColor = this.getRGBColor(this.editColorRGBs[5]);
                comboColor = this.comboColors[5];
            }
            if (sourceField.getParent().equals(this.panelRGBs[6])) {
                oldColor = this._player.getShoeColor();
                newColor = this.getRGBColor(this.editColorRGBs[6]);
                comboColor = this.comboColors[6];
            }
            if (newColor != oldColor) {
                AppearanceSubPanel.setColorComboBox(comboColor, newColor);
                Data.setCharacterDirty();
            }
        }
    }

    private void populateColorComboBoxes() {
        AppearanceSubPanel.setColorComboBox(this.comboColors[0], this._player.getHairColor());
        AppearanceSubPanel.setColorComboBox(this.comboColors[1], this._player.getSkinColor());
        AppearanceSubPanel.setColorComboBox(this.comboColors[2], this._player.getEyeColor());
        AppearanceSubPanel.setColorComboBox(this.comboColors[3], this._player.getOShirtColor());
        AppearanceSubPanel.setColorComboBox(this.comboColors[4], this._player.getUShirtColor());
        AppearanceSubPanel.setColorComboBox(this.comboColors[5], this._player.getPantsColor());
        AppearanceSubPanel.setColorComboBox(this.comboColors[6], this._player.getShoeColor());
    }

    private static void setColorComboBox(JComboBox combobox, Color color) {
        if (combobox != null) {
            Color approxColor = AppearanceSubPanel.approxColor(color);
            combobox.setSelectedItem(approxColor);
            ColorComboRenderer renderer = (ColorComboRenderer)combobox.getRenderer();
            renderer.setCurrentObject(approxColor);
            combobox.setEnabled(true);
        }
    }

    private void populateColorRGBs() {
        this.setColorRGB(this.editColorRGBs[0], this._player.getHairColor());
        this.setColorRGB(this.editColorRGBs[1], this._player.getSkinColor());
        this.setColorRGB(this.editColorRGBs[2], this._player.getEyeColor());
        this.setColorRGB(this.editColorRGBs[3], this._player.getOShirtColor());
        this.setColorRGB(this.editColorRGBs[4], this._player.getUShirtColor());
        this.setColorRGB(this.editColorRGBs[5], this._player.getPantsColor());
        this.setColorRGB(this.editColorRGBs[6], this._player.getShoeColor());
    }

    private static Color approxColor(Color color) {
        int[] rgbIn = new int[3];
        int[] rgbOut = new int[3];
        rgbIn[0] = color.getRed();
        rgbIn[1] = color.getGreen();
        rgbIn[2] = color.getBlue();
        int index = 0;
        while (index < rgbIn.length) {
            if (rgbIn[index] < 32) {
                rgbOut[index] = 0;
            } else if (rgbIn[index] >= 32 && rgbIn[index] < 96) {
                rgbOut[index] = 64;
            } else if (rgbIn[index] >= 96 && rgbIn[index] < 160) {
                rgbOut[index] = 128;
            } else if (rgbIn[index] >= 160 && rgbIn[index] < 224) {
                rgbOut[index] = 192;
            } else if (rgbIn[index] >= 224) {
                rgbOut[index] = 255;
            }
            ++index;
        }
        Color result = new Color(rgbOut[0], rgbOut[1], rgbOut[2]);
        return result;
    }

    private void changeHairColor() {
        ImageIcon icon = this._selectedHairStyle.getHairImage();
        icon = this.updateIcon(icon, this._selectedHairColor, this.imageHair);
        Data.getView().getEquipmentPanel().setHair(icon);
    }

    private ImageIcon updateIcon(ImageIcon icon, Color color, JLabel image) {
        BufferedImage bImage = GUI.convertIconToBufferedImage(icon);
        bImage = image.equals(this.imageEyes) ? this.changeImageColor(bImage, 180, color) : this.changeImageColor(bImage, color);
        bImage = GUI.scaleImage(bImage);
        ImageIcon result = new ImageIcon(bImage);
        image.setIcon(result);
        return result;
    }

    private BufferedImage changeImageColor(BufferedImage image, int oldGray, Color newColor) {
        BufferedImage result = image;
        Color oldColor = new Color(oldGray, oldGray, oldGray);
        int oldRGB = oldColor.getRGB();
        int newRGB = newColor.getRGB();
        int x = 0;
        while (x < image.getWidth()) {
            int y = 0;
            while (y < image.getHeight()) {
                if (image.getRGB(x, y) == oldRGB) {
                    result.setRGB(x, y, newRGB);
                }
                ++y;
            }
            ++x;
        }
        return result;
    }

    private BufferedImage changeImageColor(BufferedImage image, Color newColor) {
        int x = 0;
        while (x < image.getWidth()) {
            int y = 0;
            while (y < image.getHeight()) {
                int imgRGB = image.getRGB(x, y);
                if (imgRGB != 0) {
                    Color imgColor = new Color(imgRGB);
                    Color mixColor = this.multiplyColors(imgColor, newColor);
                    image.setRGB(x, y, mixColor.getRGB());
                }
                ++y;
            }
            ++x;
        }
        return image;
    }

    private Color multiplyColors(Color imgColor, Color newColor) {
        if (this.isEdgeColor(imgColor)) {
            imgColor = new Color(150, 150, 150);
        }
        float[] imgComp = imgColor.getRGBComponents(null);
        float[] newComp = newColor.getRGBComponents(null);
        float[] resComp = new float[3];
        int index = 0;
        while (index < 3) {
            resComp[index] = imgComp[index] * newComp[index];
            ++index;
        }
        Color result = new Color(resComp[0], resComp[1], resComp[2]);
        return result;
    }

    public boolean isEdgeColor(Color color) {
        boolean result = false;
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        if (red == 0 && green == 0 && blue == 0) {
            result = true;
        }
        if (red == 50 && green == 50 && blue == 50) {
            result = true;
        }
        return result;
    }

    private Color getRGBColor(JTextField[] editColorFields) {
        int red = Integer.parseInt(editColorFields[0].getText());
        int green = Integer.parseInt(editColorFields[1].getText());
        int blue = Integer.parseInt(editColorFields[2].getText());
        Color result = new Color(red, green, blue);
        return result;
    }

    private void setColorRGB(JTextField[] editColorFields, Color color) {
        editColorFields[0].setText(String.valueOf(color.getRed()));
        editColorFields[0].setEnabled(true);
        editColorFields[1].setText(String.valueOf(color.getGreen()));
        editColorFields[1].setEnabled(true);
        editColorFields[2].setText(String.valueOf(color.getBlue()));
        editColorFields[2].setEnabled(true);
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(GUI.setupAreaBorder("Appearance"));
        this.setOpaque(false);
        this.panelHairColors = new JPanel(new BorderLayout());
        this.panelHairColors.setOpaque(false);
        this.panelHairstyle = new JPanel(new BorderLayout());
        this.panelHairstyle.setOpaque(false);
        this.panelColors = new JPanel(new BorderLayout());
        this.panelColors.setOpaque(false);
        this.panelColors.setBorder(GUI.setupAreaBorder("Colors"));
        this.panelColorLabels = new JPanel(new SpringLayout());
        this.panelColorLabels.setOpaque(false);
        this.layoutcardColorCards = new CardLayout();
        this.panelColorCards = new JPanel(this.layoutcardColorCards);
        this.panelColorCards.setOpaque(false);
        this.panelSelectors = new JPanel(new SpringLayout());
        this.panelSelectors.setOpaque(false);
        this.panelRGB = new JPanel(new SpringLayout());
        this.panelRGB.setOpaque(false);
        this.panelRGBTitles = new JPanel(new GridLayout(1, 3));
        this.panelRGBTitles.setOpaque(false);
        this.panelColorSpacer = new JPanel(new GridLayout(0, 1));
        this.panelColorSpacer.setOpaque(false);
        this.panelHairImage = new JPanel(new BorderLayout());
        this.panelHairImage.setOpaque(false);
        this.labelHairstyle = new JLabel(" Hair Style:  ");
        this.labelHairstyle.setFont(GUI.fontSsP14);
        this.labelHairstyle.setHorizontalAlignment(4);
        this.comboHairStyle = this.createHairstyleCombo();
        this.hairCellRenderer = new HairCellRenderer();
        this.comboHairStyle.setRenderer(this.hairCellRenderer);
        this.comboColors[0] = this.createCharacterColorCombo(GUI.colorHair);
        this.comboColors[1] = this.createCharacterColorCombo(GUI.colorSkin);
        this.comboColors[2] = this.createCharacterColorCombo(GUI.colorEyes);
        this.comboColors[3] = this.createCharacterColorCombo(GUI.colorOShirt);
        this.comboColors[4] = this.createCharacterColorCombo(GUI.colorUShirt);
        this.comboColors[5] = this.createCharacterColorCombo(GUI.colorPants);
        this.comboColors[6] = this.createCharacterColorCombo(GUI.colorShoes);
        int index = 0;
        while (index < 7) {
            this.panelRGBs[index] = this.createColorRGBPanel();
            this.editColorRGBs[index] = this.createColorEditFields(this.panelRGBs[index]);
            ++index;
        }
        this.panelImage = new JPanel(null);
        this.panelImage.setOpaque(false);
        this.imageHair = GUI.setupCharacterImage(this.panelImage, GUI.Icon_Hair, 0, 0);
        this.imageEyes = GUI.setupCharacterImage(this.panelImage, GUI.Icon_Eyes, 5, 9);
        this.imageHead = GUI.setupCharacterImage(this.panelImage, GUI.Icon_Head, 0, 0);
        this.imageHand = GUI.setupCharacterImage(this.panelImage, GUI.Icon_Hand, 0, 47);
        this.imageUShi = GUI.setupCharacterImage(this.panelImage, GUI.Icon_UShi, 0, 47);
        this.imageOShi = GUI.setupCharacterImage(this.panelImage, GUI.Icon_OShi, 0, 47);
        this.imageShoe = GUI.setupCharacterImage(this.panelImage, GUI.Icon_Shoe, 0, 84);
        this.imagePant = GUI.setupCharacterImage(this.panelImage, GUI.Icon_Pant, 0, 84);
        this.add((Component)this.panelHairColors, "West");
        this.panelHairColors.add((Component)this.panelHairstyle, "North");
        this.panelHairstyle.add((Component)this.labelHairstyle, "West");
        this.panelHairstyle.add((Component)this.comboHairStyle, "Center");
        this.panelHairColors.add((Component)this.panelColors, "Center");
        this.panelColors.add((Component)this.panelColorLabels, "West");
        this.panelColorLabels.add(new JLabel(" "));
        this.panelColorLabels.add(this.createColorLabel("Hair"));
        this.panelColorLabels.add(this.createColorLabel("Skin"));
        this.panelColorLabels.add(this.createColorLabel("Eyes"));
        this.panelColorLabels.add(this.createColorLabel("OShirt"));
        this.panelColorLabels.add(this.createColorLabel("UShirt"));
        this.panelColorLabels.add(this.createColorLabel("Pants"));
        this.panelColorLabels.add(this.createColorLabel("Shoes"));
        SpringUtilities.makeCompactGrid(this.panelColorLabels, 8, 1, 5, 5, 5, 8);
        this.panelColors.add((Component)this.panelColorCards, "Center");
        this.panelColorCards.add((Component)this.panelSelectors, CARD_SELECTORS);
        this.panelSelectors.add(new JLabel(" "));
        index = 0;
        while (index < 7) {
            this.panelSelectors.add(this.comboColors[index]);
            ++index;
        }
        SpringUtilities.makeCompactGrid(this.panelSelectors, 8, 1, 5, 5, 5, 8);
        this.panelColorCards.add((Component)this.panelRGB, CARD_RGBS);
        this.panelRGB.add(this.panelRGBTitles);
        this.panelRGBTitles.add(new JLabel("R", 0));
        this.panelRGBTitles.add(new JLabel("G", 0));
        this.panelRGBTitles.add(new JLabel("B", 0));
        index = 0;
        while (index < 7) {
            this.panelRGB.add(this.panelRGBs[index]);
            ++index;
        }
        SpringUtilities.makeCompactGrid(this.panelRGB, 8, 1, 5, 5, 5, 5);
        this.panelHairColors.add((Component)this.panelColorSpacer, "South");
        this.panelColorSpacer.add(new JLabel(" "));
        this.panelColorSpacer.add(new JLabel(" "));
        this.panelColorSpacer.add(new JLabel(" "));
        this.panelColorSpacer.add(new JLabel(" "));
        this.panelColorSpacer.add(new JLabel(" "));
        this.panelColorSpacer.add(new JLabel(" "));
        this.panelColorSpacer.add(new JLabel(" "));
        this.add((Component)this.panelImage, "Center");
        this.panelImage.add(this.imageHair);
        this.panelImage.add(this.imageEyes);
        this.panelImage.add(this.imageHead);
        this.panelImage.add(this.imageHand);
        this.panelImage.add(this.imageUShi);
        this.panelImage.add(this.imageOShi);
        this.panelImage.add(this.imageShoe);
        this.panelImage.add(this.imagePant);
    }

    private JLabel createColorLabel(String label) {
        JLabel result = new JLabel(String.valueOf(label) + ":");
        result.setFont(GUI.fontSsP14);
        return result;
    }

    private JComboBox createHairstyleCombo() {
        HairObject[] hairObjects = new HairObject[32];
        int index = 0;
        while (index < hairObjects.length) {
            hairObjects[index] = HairObjectDAO.getHairObjectByNum(index + 1);
            ++index;
        }
        JComboBox<HairObject> result = new JComboBox<HairObject>(hairObjects);
        result.setFont(GUI.fontSsB14);
        result.setEnabled(false);
        result.addActionListener(this.listenerComboHairStyle);
        result.setFont(GUI.fontSsB14);
        FontMetrics fontMetrics = result.getFontMetrics(result.getFont());
        int labelWidth = fontMetrics.stringWidth(Integer.toString(32));
        int width = GUI.DIM_ICON.width * 2 + labelWidth;
        result.setPreferredSize(new Dimension(width, GUI.DIM_ICON.height));
        result.setMinimumSize(new Dimension(width, GUI.DIM_ICON.height));
        result.setMaximumSize(new Dimension(width, GUI.DIM_ICON.height));
        result.setOpaque(false);
        result.setBackground(GUI.colorHairCell);
        return result;
    }

    private JComboBox createCharacterColorCombo(Color defaultColor) {
        JComboBox<Color> result = new JComboBox<Color>(Data.getCharacterColorChoices());
        result.setRenderer(new ColorComboRenderer());
        result.setFont(GUI.fontSsB14);
        String blank = "                             ";
        FontMetrics fontMetrics = result.getFontMetrics(result.getFont());
        int width = fontMetrics.stringWidth(blank);
        result.setPreferredSize(new Dimension(width, fontMetrics.getHeight()));
        result.setMinimumSize(new Dimension(width, fontMetrics.getHeight()));
        result.setMaximumSize(new Dimension(width, fontMetrics.getHeight()));
        AppearanceSubPanel.setColorComboBox(result, defaultColor);
        result.setEnabled(false);
        result.addActionListener(this.listenerComboColor);
        return result;
    }

    private JTextField[] createColorEditFields(JPanel panelRGBField) {
        JTextField[] result = new JTextField[3];
        int index = 0;
        while (index < result.length) {
            JTextField editField = new JTextField("0", 3);
            editField.addFocusListener(this.listenerFocusColor);
            editField.setBackground(GUI.colorEditBack);
            editField.setBorder(GUI.borderEditField);
            editField.setDocument(new DocumentInteger(editField, 3));
            editField.setFont(GUI.fontSsB10);
            editField.setHorizontalAlignment(4);
            editField.setDisabledTextColor(GUI.colorDisabled);
            editField.setEnabled(false);
            result[index] = editField;
            panelRGBField.add(editField);
            ++index;
        }
        return result;
    }

    private JPanel createColorRGBPanel() {
        JPanel result = new JPanel(new GridLayout(1, 3));
        result.setOpaque(false);
        return result;
    }
}

