/*
 * Decompiled with CFR 0.152.
 */
package com.su.slytherin.terraria;

import com.su.slytherin.terraria.Razdor;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ArrayIterator<T>
implements Iterator<T> {
    private final T[] arr;
    private final int length;
    private int position;

    public ArrayIterator(T[] array) {
        Razdor.requireReal(array, "Array can't be null!");
        this.length = array.length;
        this.arr = array;
    }

    public static <T> ArrayIterator<T> wrap(T[] arr) {
        return new ArrayIterator<T>(arr);
    }

    @Override
    public boolean hasNext() {
        return this.position < this.length;
    }

    @Override
    public T next() {
        if (this.position >= this.length) {
            throw new NoSuchElementException("Position: " + this.position + ", Length: " + this.length);
        }
        return this.arr[this.position++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove elements.");
    }
}

