/*
 * Decompiled with CFR 0.152.
 */
package com.su.slytherin.terraria;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public final class TerrReader {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private final ByteBuffer _buffer;

    public TerrReader(ByteBuffer buffer) {
        this._buffer = buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public TerrReader(byte[] array) {
        this(ByteBuffer.wrap(array));
    }

    public byte get() {
        return this._buffer.get();
    }

    public TerrReader get(byte[] array, int offset, int length) {
        this._buffer.get(array, offset, length);
        return this;
    }

    public byte[] getArray(int length) {
        byte[] arr = new byte[length];
        this._buffer.get(arr, 0, length);
        return arr;
    }

    public boolean getBoolean() {
        return this._buffer.get() != 0;
    }

    public Color getColor() {
        return new Color(this.getUnsigned(), this.getUnsigned(), this.getUnsigned());
    }

    public double getDouble() {
        return this._buffer.getDouble();
    }

    public float getFloat() {
        return this._buffer.getFloat();
    }

    public int getInt() {
        return this._buffer.getInt();
    }

    public long getLong() {
        return this._buffer.getLong();
    }

    public Point getPoint() {
        return new Point(this.getInt(), this.getInt());
    }

    public Rectangle getRectangle() {
        return new Rectangle(this.getInt(), this.getInt(), this.getInt(), this.getInt());
    }

    public String getString() {
        String result = "";
        int length = this.readStringLength();
        if (length != 0) {
            if (length >= 0) {
                if (length > this._buffer.limit() - this._buffer.position()) {
                    throw new RuntimeException("Impossibly long String");
                }
                ByteBuffer buffer = ByteBuffer.wrap(this.getArray(length));
                CharBuffer chars = CHARSET.decode(buffer);
                assert (chars.hasArray()) : "CharBuffer has no array!";
                result = String.valueOf(chars.array());
            } else {
                throw new NegativeArraySizeException("Negative String length.");
            }
        }
        return result;
    }

    public char getUnsigned() {
        return (char)(this._buffer.get() & 0xFF);
    }

    public int capacity() {
        return this._buffer.capacity();
    }

    public int limit() {
        return this._buffer.limit();
    }

    public int position() {
        return this._buffer.position();
    }

    public TerrReader position(int newPosition) {
        this._buffer.position(newPosition);
        return this;
    }

    public TerrReader seek(int distance) {
        this._buffer.position(this._buffer.position() + distance);
        return this;
    }

    public TerrReader duplicate() {
        return new TerrReader(this._buffer.duplicate());
    }

    private int readStringLength() {
        int result = 0;
        int shift = 0;
        int length = 0;
        while (length < 5) {
            byte bite = this.get();
            result |= (bite & 0x7F) << shift;
            shift += 7;
            if ((bite & 0x80) == 0) break;
            ++length;
        }
        if (length >= 5) {
            throw new RuntimeException("Invalid string length encoding.");
        }
        return result;
    }
}

